<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="robots" content="noindex,nofollow">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Roster') }}</title>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>
    <script src="window.print();"></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">

    <!-- Table -->
    <style>
        .container {
            margin; 5px;
        }
    h3 {
        text-align:center;
        font-size:24px;
        }
    h4 {
        text-align:center;
        font-size:16px;
        }
    table, tr {
        align:left;
        border: 0px solid black;
        border-collapse: collapse;
    }
    table {
           margin: 5px 0 0 0;  
        }
        .name {
        font-size: 16px;
        line-height: 16px;
        color: red;
        }
    td {
        font-size: 14px;
    }
    header {
        text-align: center;
    }
    .section {
        column-count: 5;
    }

    @page {
        margin: .5in .5in .5in .5in;
        size: 8.5in 11in portrait;
        }    
    @media print { 
    p {
        font-family: Arial, Helvetica, sans-serif, serif;
        font-size: 16px;
        color: blue;
        }
        .content-block {
            page-break-inside: avoid;
        }
        
        #printPageButton {
            display: none;
        }
        .headline {
        text-align:center;
        font-size:24px;
        }
        .player {margin: 5px 5px 5px 5px;
                font-size: 16px;
                border: 0px solid #000000;
                float: left;
                padding:3px;
                width: 45%;
                height:95px;
        }
        button {
            text-align:center;
        }
        .name {
        font-size: 14px;
        line-height: 14px;
        color: #000000;
        }
        table {
            height: 50px;
            break-after: always;
            border: 1px solid #cccccc;
        }
    }
    
    </style>
</head>
<body>
    <div id="app">
        @include('inc.navbar') 
                @include('inc.messages')
                @yield('content')
            </main>
        </div>
    </div>
</body>
</html>