@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Dashboard</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <a href="/posts/create" class="btn btn-primary">Add a Player</a> 
                    <a href="/pay" class="btn btn-primary">Pay</a>
                    <a href="/game" class="btn btn-primary">Game Roster</a>
                    <br>
                    <hr>
                    <h3>Your Players</h3>
                    <table class="table table-striped">
                        <tr>
                            <th>Photo</th>
                            <th>Last</th>
                            <th>First</th>
                            <th>Added</th>
                            <th></th>
                        </tr>
                        @foreach ($posts as $post)
                        <tr>
                            <td><img style="width:50px" src="/storage/player_images/{{$post->player_image}}"></td>
                            <td>{{$post->lname}}</td>
                            <td>{{$post->fname}}</td>
                            <td>{{$post->created_at}}</td>
                            <td><a href="/posts/{{$post->id}}/edit" class="btn btn-primary">Edit</a></td>
                            <td></td>
                        </tr>                            
                        @endforeach
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
