<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use App\Post;
use DB;

class PostsController extends Controller
{

    /**
     * This is here to block guests from making changes.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $posts = Post::orderBy('lname','asc')->paginate(20);
        return view('posts.index')->with('posts', $posts);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('posts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'team' => 'required', 
            'fname' => 'required', 
            'lname' => 'required',
            'dob' => 'required',  
            'address' => 'required', 
            'city' => 'required',
            'state' => 'required',  
            'zip' => 'required', 
            'pphone' => 'required',   
            'sphone' => 'nullable',
            'email' => 'required|unique:posts|email',
            'itc' => 'nullable', 
            'number' => 'nullable',  
            'pos' => 'required',
            'player_image' => 'image|nullable|max:1000'      
        ]);

        //Handle File Upload
        if($request->hasFile('player_image')) {
            //Get filename with the extension
            $filenamewithExt = $request->file('player_image')->getClientOriginalName();
            //Get just filename
            $filename = pathinfo($filenamewithExt,PATHINFO_FILENAME);          
            //Get just ext
            $extension = $request->file('player_image')->guessClientExtension();
            //FileName to store
            $fileNameToStore = $filename.'_'.time().'.'.$extension;            
            //Upload Image
            $path = $request->file('player_image')->storeAs('public/player_images/',$fileNameToStore);
        } else {
            $fileNameToStore = 'noimage.jpg';
        }

        //Create Post
        
            $post = new Post;
            $post->team = $request->input('team');
            $post->fname = $request->input('fname');
            $post->lname = $request->input('lname');
            $post->dob = $request->input('dob');
            $post->address = $request->input('address');
            $post->city = $request->input('city');
            $post->state = $request->input('state');
            $post->zip = $request->input('zip');
            $post->pphone = $request->input('pphone');
            $post->sphone = $request->input('sphone');
            $post->email = $request->input('email');
            $post->itc = $request->input('itc');
            $post->number = $request->input('number');
            $post->pos = $request->input('pos');
            $post->user_id = auth()->user()->id;
            $post->player_image = $fileNameToStore;
            $post->save();

            return redirect('/home')->with('success', 'Player Added');

        }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $post = Post::find($id);
        return view('posts.show')->with('post', $post);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $post = Post::find($id);

        // Check for correct user
        if(auth()->user()->id !=$post->user_id)
        {
            return redirect('/posts')->with('error','Unauthorized Page');
        }

        return view('posts.edit')->with('post', $post);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'team' => 'required', 
            'fname' => 'required', 
            'lname' => 'required',
            'dob' => 'required',  
            'address' => 'required', 
            'city' => 'required',
            'state' => 'required',  
            'zip' => 'required', 
            'pphone' => 'required',   
            'sphone' => 'nullable',
            'email' => 'required|unique:posts,email,' . $id,
            'itc' => 'nullable', 
            'number' => 'nullable',  
            'pos' => 'required',
            'player_image' => 'image|nullable|max:1000'        
        ]);

        //Handle File Upload
        if($request->hasFile('player_image')){
            //Get filename with the extension
            $filenamewithExt = $request->file('player_image')->getClientOriginalName();
            //Get just filename
            $filename = pathinfo($filenamewithExt,PATHINFO_FILENAME);          
            //Get just ext
            $extension = $request->file('player_image')->guessClientExtension();
            //FileName to store
            $fileNameToStore = $filename.'_'.time().'.'.$extension;            
            //Upload Image
            $path = $request->file('player_image')->storeAs('public/player_images/',$fileNameToStore);
        }

        //Create Post
        
            $post = Post::find($id);
       //     $post->team = $request->input('team');
       //     $post->fname = $request->input('fname');
       //     $post->lname = $request->input('lname');
       //     $post->dob = $request->input('dob');
            $post->address = $request->input('address');
            $post->city = $request->input('city');
            $post->state = $request->input('state');
            $post->zip = $request->input('zip');
            $post->pphone = $request->input('pphone');
            $post->sphone = $request->input('sphone');
       //   $post->email = $request->input('email');
            $post->itc = $request->input('itc');
            $post->number = $request->input('number');
            $post->pos = $request->input('pos');
            if($request->hasFile('player_image')){
            $post->player_image = $fileNameToStore;
            }
            $post->save();

            return redirect('/home')->with('success', 'Player Updated');

        }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $post = Post::find($id);

         // Check for correct user
         if(auth()->user()->id !=$post->user_id)
         {
             return redirect('/posts')->with('error','Unauthorized Page');
         }

         if($post->player_image != 'noimage.jpg')
         {
             // Delete Image
             Storage::delete('public/player_images/'.$post->player_image);
         }
         
        $post->delete();
        return redirect('/posts')->with('success', 'Post Removed');
    }
}
