@extends('layouts.app')

@section('content')
        <h1>Edit Player</h1>
        {!! Form::open(['action' => ['PostsController@update', $post->id], 'method' => 'PUT', 'enctype' => 'multipart/form-data']) !!}
            <div class="form-group">
                {{Form::label('team','Team')}}
                {{Form::text('team', $post->team, ['class' => 'form-control', 'placeholder' => 'Team'])}}
            </div>
            <div class="form-group">
                {{Form::label('fname','First Name')}}
                {{Form::text('fname', $post->fname, ['class' => 'form-control', 'placeholder' => 'First Name'])}}
            </div>
            <div class="form-group">
                {{Form::label('lname','Last Name')}}
                {{Form::text('lname', $post->lname, ['class' => 'form-control', 'placeholder' => 'Last Name'])}}
            </div>
            <div class="form-group">
                {{Form::label('dob','Date of Birth')}}
            <!--    {{Form::date('dob', \carbon\Carbon::now(), ['class' => 'form-control', 'placeholder' => 'Date of Birth'])}} -->
            {{Form::date('dob', $post->dob, ['class' => 'form-control', 'placeholder' => 'Date of Birth'])}}
            </div>
            <div class="form-group">
                {{Form::label('address','Address')}}
                {{Form::text('address', $post->address, ['class' => 'form-control', 'placeholder' => 'Address'])}}
            </div>
            <div class="form-group">
                {{Form::label('city','City')}}
                {{Form::text('city', $post->city, ['class' => 'form-control', 'placeholder' => 'City'])}}
            </div>
            <div class="form-group">
                {{Form::label('state','State')}}
                {{Form::select('state', ['CA' => 'CA', 'OR' => 'OR', 'WA' => 'WA'],['form-control', 'placeholder' => 'State'])}}
            </div>
            <div class="form-group">
                {{Form::label('zip','Zip')}}
                {{Form::text('zip', $post->zip, ['class' => 'form-control', 'placeholder' => 'Zip Code'])}}
            </div>
            <div class="form-group">
                {{Form::label('pphone','Primary Phone')}}
                {{Form::text('pphone', $post->pphone, ['class' => 'form-control', 'placeholder' => 'Primary Phone'])}}
            </div>
            <div class="form-group">
                {{Form::label('sphone','Secondary Phone')}}
                {{Form::text('sphone', $post->sphone, ['class' => 'form-control', 'placeholder' => 'Secondary Phone'])}}
            </div>
            <div class="form-group">
                {{Form::label('email','email')}}
                {{Form::text('email', $post->email, ['class' => 'form-control', 'placeholder' => 'email'])}}
            </div>
            <div class="form-group">
                {{Form::label('itc','Country holding International Transfer Clearance')}}
                {{Form::text('itc', $post->itc, ['class' => 'form-control', 'placeholder' => 'Country holding ITC'])}}
            </div>
                <div class="form-group">
                {{Form::label('number','Uniform Number')}}
                {{Form::text('number', $post->number, ['class' => 'form-control', 'placeholder' => 'Uniform Number'])}}
            </div>
            <div class="form-group">
                {{Form::label('pos','Position')}}
                {{Form::select('pos', ['P' => 'Player', 'S' => 'Staff',],['form-control', 'placeholder' => 'Position'])}}
            </div>
        <!--    <div class="form-group">
                Player mug shot must clearly show face and be .jpg or .png file.<br><br>
                {{Form::file('player_image')}}
            </div> -->
            {{Form::hidden('_method','PUT')}}
            {{Form::submit('Submit Player', ['class' =>'btn btn-primary'])}}
        {!! Form::close() !!} 
        <br><a href="/home" class="btn btn-primary">Back</a>   
        <hr>
        <br>     
@endsection